/* ============================================
   SMSA EXPRESS - SUCCESS FLOW MANAGEMENT
   Page finale avec récupération des données
   ============================================ */

document.addEventListener('DOMContentLoaded', function() {
    // Récupérer les données de paiement
    const paymentData = JSON.parse(sessionStorage.getItem('paymentData') || '{}');
    
    // Remplir les détails de la transaction
    populateSuccessDetails(paymentData);
    
    // Générer le numéro de référence
    generateReferenceNumber();
    
    // Définir la date actuelle
    setCurrentDate();
    
    // Ajouter l'animation au chargement
    addLoadAnimation();
});

// Remplir les détails de succès
function populateSuccessDetails(paymentData) {
    if (paymentData.tracking_number) {
        const trackingElement = document.getElementById('tracking-num');
        if (trackingElement) {
            trackingElement.textContent = paymentData.tracking_number;
        }
    }
    
    if (paymentData.delivery_fee) {
        const amountElement = document.getElementById('amount-paid');
        if (amountElement) {
            amountElement.textContent = paymentData.delivery_fee;
        }
    }
}

// Générer le numéro de référence
function generateReferenceNumber() {
    const timestamp = Date.now().toString().slice(-6);
    const refNumber = `TXN-${new Date().getFullYear()}-${timestamp}`;
    const refElement = document.getElementById('ref-number');
    if (refElement) {
        refElement.textContent = refNumber;
    }
}

// Définir la date actuelle
function setCurrentDate() {
    const lang = document.documentElement.lang === 'ar';
    const options = lang ? 
        { year: 'numeric', month: 'long', day: '2-digit' } : 
        { year: 'numeric', month: 'short', day: '2-digit' };
    
    const locale = lang ? 'ar-SA' : 'en-US';
    const today = new Date().toLocaleDateString(locale, options);
    
    const dateElement = document.getElementById('payment-date');
    if (dateElement) {
        dateElement.textContent = today;
    }
}

// Ajouter l'animation au chargement
function addLoadAnimation() {
    const successContent = document.querySelector('.success-content');
    if (successContent) {
        successContent.style.animation = 'slideIn 0.5s ease-out';
    }
    
    // Ajouter les styles d'animation s'ils ne sont pas présents
    if (!document.getElementById('success-animation-styles')) {
        const style = document.createElement('style');
        style.id = 'success-animation-styles';
        style.textContent = `
            @keyframes slideIn {
                from {
                    opacity: 0;
                    transform: translateY(20px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
        `;
        document.head.appendChild(style);
    }
}

// Gérer l'impression du reçu
function handlePrintReceipt() {
    window.print();
}

// Nettoyer les données de session à la fin
window.addEventListener('beforeunload', function() {
    // Garder les données pour le retour à la page d'accueil
    // Mais les effacer si l'utilisateur quitte complètement
});
