/* ============================================
   SMSA EXPRESS - LOADING PAYMENT FLOW
   Redirection : Loading Payment → OTP
   ============================================ */

document.addEventListener('DOMContentLoaded', function() {
    // Simulate payment processing
    let currentStep = 1;
    const steps = document.querySelectorAll('.step');
    
    function updateStep() {
        currentStep++;
        if (currentStep <= steps.length) {
            steps[currentStep - 2].classList.remove('active');
            steps[currentStep - 2].classList.add('completed');
            steps[currentStep - 2].querySelector('.step-number').textContent = '✓';
            
            if (currentStep <= steps.length) {
                steps[currentStep - 1].classList.add('active');
            }
        }
    }

    // Update steps every 2 seconds
    let stepInterval = setInterval(updateStep, 2000);

    // Simulate completion after 3 seconds and redirect to OTP
    setTimeout(() => {
        clearInterval(stepInterval);
        steps.forEach(step => {
            step.classList.remove('active');
            step.classList.add('completed');
            step.querySelector('.step-number').textContent = '✓';
        });
        
        // Redirect to OTP page after 1 second
        setTimeout(() => {
            const lang = document.documentElement.lang === 'ar' ? '_ar' : '';
            window.location.href = `otp${lang}.html`;
        }, 1000);
    }, 3000);
});
