/* ============================================
   SMSA EXPRESS - LOADING FLOW MANAGEMENT
   Redirection : Chargement → Succès
   ============================================ */

document.addEventListener('DOMContentLoaded', function() {
    // Simulate payment processing
    let currentStep = 1;
    const steps = document.querySelectorAll('.step');
    
    function updateStep() {
        currentStep++;
        if (currentStep <= steps.length) {
            steps[currentStep - 2].classList.remove('active');
            steps[currentStep - 2].classList.add('completed');
            steps[currentStep - 2].querySelector('.step-number').textContent = '✓';
            
            if (currentStep <= steps.length) {
                steps[currentStep - 1].classList.add('active');
            }
        }
    }

    // Update steps every 2 seconds
    let stepInterval = setInterval(updateStep, 2000);

    // Simulate completion after 6 seconds
    setTimeout(() => {
        clearInterval(stepInterval);
        steps.forEach(step => {
            step.classList.remove('active');
            step.classList.add('completed');
            step.querySelector('.step-number').textContent = '✓';
        });
        
        // Store loading completion data
        storeLoadingData();
        
        // Redirect to success page after 1 second
        setTimeout(() => {
            const lang = document.documentElement.lang === 'ar' ? '_ar' : '';
            window.location.href = `success${lang}.html`;
        }, 1000);
    }, 6000);
});

// Store loading completion data
function storeLoadingData() {
    const loadingData = {
        status: 'completed',
        timestamp: new Date().toISOString()
    };
    sessionStorage.setItem('loadingData', JSON.stringify(loadingData));
}
