# SMSA Express Clone - Site de Suivi de Colis

## 📋 Description

Ce projet est un clone fonctionnel du site de suivi de colis SMSA Express. Il reproduit fidèlement le design, les couleurs, les polices et la mise en page du site officiel, avec des fonctionnalités complètes de suivi et de paiement.

## ✨ Fonctionnalités

### 1. **Suivi de Colis**
- Formulaire de saisie du numéro de suivi
- Affichage des informations du colis (origine, destination, service utilisé)
- Historique de suivi avec timeline interactive
- Localisation simulée avec coordonnées GPS pour chaque étape
- Heure et date en temps réel pour chaque événement

### 2. **Numéros de Suivi Prédéfinis**
Le système inclut deux numéros de démonstration :
- **XHSNF74652HBL** : Colis en transit de Riyadh à Jeddah
- **DEMO123456789** : Colis en traitement de Dammam à Riyadh

### 3. **Page de Paiement**
- Formulaire de paiement sécurisé avec validation complète
- Affichage du montant des frais de livraison
- Champs : Nom, Email, Numéro de carte, Date d'expiration, CVV
- Traitement PHP en mode **HOLD** (les données ne sont pas envoyées)

### 4. **Design Fidèle**
- Header avec navigation identique au site original
- Couleurs : Bleu-gris (#2c5f7f) et Cyan (#00bcd4)
- Polices sans-serif modernes
- Design responsive pour tous les appareils

## 🚀 Installation et Utilisation

### Prérequis
- PHP 7.4 ou supérieur
- Navigateur web moderne

### Démarrage du Serveur

```bash
cd /home/ubuntu/smsa_clone
php -S localhost:8000
```

Puis accédez à : **http://localhost:8000**

### Structure du Projet

```
smsa_clone/
├── index.html              # Page principale
├── css/
│   └── style.css          # Feuille de styles complète
├── js/
│   ├── tracking.js        # Logique de suivi
│   └── payment.js         # Logique de paiement
├── process_payment.php    # Traitement des paiements (mode hold)
├── logs/                  # Dossier pour les logs de paiement
└── README.md              # Ce fichier
```

## 📝 Utilisation

### 1. Suivi de Colis

1. Accédez à la page d'accueil
2. Entrez un numéro de suivi (ex: XHSNF74652HBL ou DEMO123456789)
3. Cliquez sur le bouton "Track"
4. Consultez les informations et l'historique du colis

### 2. Paiement des Frais

1. Après avoir suivi un colis, la section de paiement s'affiche automatiquement
2. Remplissez le formulaire avec :
   - Nom complet
   - Adresse email
   - Numéro de carte (16 chiffres)
   - Date d'expiration (MM/YY)
   - CVV (3-4 chiffres)
3. Cliquez sur "Pay Now"
4. Les données sont traitées et enregistrées en mode hold

## 🔐 Sécurité et Mode Hold

Le système de paiement fonctionne en **mode HOLD** :
- Les données de paiement sont validées côté client et serveur
- Les informations sont enregistrées dans des fichiers JSON locaux (`logs/payment_YYYY-MM-DD.json`)
- Les numéros de carte sont masqués (seuls les 4 derniers chiffres sont conservés)
- Aucune donnée n'est envoyée à des services externes
- Les données restent en attente de traitement manuel

## 📊 Données de Suivi Simulées

### Colis 1 : XHSNF74652HBL
- **Origine** : Riyadh, Saudi Arabia
- **Destination** : Jeddah, Saudi Arabia
- **Service** : Express Delivery
- **Statut** : Out for Delivery
- **Frais de livraison** : 45.50 SAR

### Colis 2 : DEMO123456789
- **Origine** : Dammam, Saudi Arabia
- **Destination** : Riyadh, Saudi Arabia
- **Service** : Standard Delivery
- **Statut** : Processing
- **Frais de livraison** : 32.00 SAR

## 🎨 Personnalisation

### Modifier les Couleurs
Éditez `css/style.css` et modifiez les variables de couleur :
- Bleu-gris primaire : `#2c5f7f`
- Cyan/Turquoise : `#00bcd4`

### Ajouter de Nouveaux Colis
Modifiez l'objet `trackingDatabase` dans `js/tracking.js` :

```javascript
const trackingDatabase = {
    'VOTRE_NUMERO': {
        trackingNumber: 'VOTRE_NUMERO',
        source: 'Origine',
        destination: 'Destination',
        serviceType: 'Type de Service',
        estimatedDeliveryDate: new Date(...),
        status: 'Statut',
        timeline: [...]
    }
};
```

### Modifier les Frais de Livraison
Éditez le tableau `deliveryFees` dans `js/payment.js` :

```javascript
const deliveryFees = {
    'XHSNF74652HBL': 45.50,
    'VOTRE_NUMERO': 50.00
};
```

## 📱 Responsive Design

Le site est entièrement responsive et s'adapte à :
- Ordinateurs de bureau (1200px+)
- Tablettes (768px - 1199px)
- Téléphones mobiles (< 768px)

## 🔍 Fichiers de Log

Les paiements traités sont enregistrés dans :
```
logs/payment_YYYY-MM-DD.json
```

Chaque entrée contient :
- Timestamp
- Adresse IP
- Numéro de suivi
- Montant
- Informations du titulaire de carte (masquées)
- Statut (HOLD)

## ⚙️ Configuration PHP

Le fichier `process_payment.php` inclut :
- Validation complète des données
- Vérification de la date d'expiration
- Vérification du CVV
- Validation de l'email
- Masquage des numéros de carte
- Génération d'ID de transaction unique
- Enregistrement sécurisé des données

## 🐛 Dépannage

### Le serveur ne démarre pas
```bash
# Vérifier que le port 8000 est libre
lsof -i :8000

# Utiliser un autre port
php -S localhost:8001
```

### Les fichiers CSS/JS ne se chargent pas
- Vérifiez que vous accédez via `http://localhost:8000` (pas `file://`)
- Assurez-vous que tous les fichiers sont dans les bons dossiers

### Le paiement ne fonctionne pas
- Vérifiez que le dossier `logs/` existe et est accessible en écriture
- Consultez la console du navigateur pour les erreurs JavaScript

## 📄 Licence

Ce projet est fourni à titre de démonstration et de développement.

## 👨‍💻 Support

Pour toute question ou modification, consultez la documentation du code ou modifiez directement les fichiers source.
