# Guide d'Installation - SMSA Express Clone

## 🖥️ Prérequis Système

- **Système d'exploitation** : Linux, macOS ou Windows (avec WSL)
- **PHP** : Version 7.4 ou supérieure
- **Navigateur** : Chrome, Firefox, Safari, Edge (versions récentes)
- **Éditeur de texte** : VSCode, Sublime Text, ou tout autre éditeur

## 📦 Installation de PHP

### Sur Ubuntu/Debian
```bash
sudo apt-get update
sudo apt-get install php php-cli php-fpm
```

### Sur macOS (avec Homebrew)
```bash
brew install php
```

### Sur Windows
Téléchargez PHP depuis [php.net](https://www.php.net/downloads) ou utilisez XAMPP/WAMP.

## 🚀 Démarrage Rapide

### 1. Accéder au Dossier du Projet
```bash
cd /home/ubuntu/smsa_clone
```

### 2. Démarrer le Serveur PHP
```bash
php -S localhost:8000
```

Vous devriez voir :
```
[Fri Feb  6 05:00:03 2026] PHP 8.1.2 Development Server (http://localhost:8000) started
```

### 3. Ouvrir dans le Navigateur
Accédez à : **http://localhost:8000**

## 🧪 Test des Fonctionnalités

### Test 1 : Suivi de Colis
1. Entrez `XHSNF74652HBL` dans le champ de suivi
2. Cliquez sur "Track"
3. Vérifiez que les informations du colis s'affichent
4. Consultez la timeline avec les étapes de livraison

### Test 2 : Suivi Alternative
1. Entrez `DEMO123456789`
2. Cliquez sur "Track"
3. Vérifiez les informations différentes

### Test 3 : Paiement
1. Après un suivi réussi, la section de paiement s'affiche
2. Remplissez le formulaire avec des données de test :
   - **Nom** : John Doe
   - **Email** : john@example.com
   - **Carte** : 4111 1111 1111 1111
   - **Expiration** : 12/25
   - **CVV** : 123
3. Cliquez sur "Pay Now"
4. Vérifiez le message de succès

### Test 4 : Validation des Formulaires
- Essayez de soumettre sans remplir les champs
- Entrez un numéro de carte invalide
- Entrez une date d'expiration expirée
- Vérifiez que les messages d'erreur s'affichent

## 📁 Structure des Fichiers

```
smsa_clone/
│
├── index.html                 # Page HTML principale
├── process_payment.php        # Script de traitement des paiements
├── README.md                  # Documentation générale
├── INSTALLATION.md            # Ce fichier
│
├── css/
│   └── style.css             # Feuille de styles (10KB)
│
├── js/
│   ├── tracking.js           # Logique de suivi (7KB)
│   └── payment.js            # Logique de paiement (6KB)
│
├── logs/                      # Dossier pour les fichiers de log
│   └── payment_YYYY-MM-DD.json
│
├── images/                    # Dossier pour les images (vide)
└── includes/                  # Dossier pour les includes PHP (vide)
```

## 🔧 Configuration Avancée

### Utiliser un Port Différent
```bash
php -S localhost:8001
```

### Utiliser une Adresse IP Spécifique
```bash
php -S 192.168.1.100:8000
```

### Activer les Logs PHP
Créez un fichier `.htaccess` ou modifiez `php.ini` :
```ini
error_reporting = E_ALL
display_errors = On
log_errors = On
error_log = /var/log/php_errors.log
```

## 🔐 Sécurité en Production

**⚠️ IMPORTANT** : Le serveur PHP intégré n'est pas destiné à la production.

Pour déployer en production, utilisez :
- **Apache** avec mod_php
- **Nginx** avec PHP-FPM
- **Docker** avec une image PHP officielle

### Configuration Apache Basique
```apache
<VirtualHost *:80>
    ServerName smsa-clone.local
    DocumentRoot /home/ubuntu/smsa_clone
    
    <Directory /home/ubuntu/smsa_clone>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

### Configuration Nginx Basique
```nginx
server {
    listen 80;
    server_name smsa-clone.local;
    root /home/ubuntu/smsa_clone;
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php-fpm.sock;
        fastcgi_index index.php;
        include fastcgi_params;
    }
}
```

## 📊 Vérification des Logs de Paiement

Les paiements traités sont enregistrés dans `logs/payment_YYYY-MM-DD.json`.

### Consulter les Logs
```bash
cat logs/payment_2026-02-06.json
```

### Format des Logs
```json
{
  "timestamp": "2026-02-06 05:00:00",
  "ip_address": "127.0.0.1",
  "tracking_number": "XHSNF74652HBL",
  "delivery_fee": 45.50,
  "cardholder_name": "John Doe",
  "email": "john@example.com",
  "card_number_masked": "****-****-****-1111",
  "expiry_date": "12/25",
  "cvv_masked": "***",
  "status": "HOLD",
  "notes": "Payment received and held for manual processing"
}
```

## 🐛 Résolution des Problèmes Courants

### Erreur : "Connection refused"
**Solution** : Vérifiez que le serveur PHP est en cours d'exécution
```bash
ps aux | grep php
```

### Erreur : "Port already in use"
**Solution** : Trouvez le processus utilisant le port
```bash
lsof -i :8000
kill -9 <PID>
```

### Fichiers CSS/JS ne se chargent pas
**Solution** : Assurez-vous d'accéder via HTTP, pas FILE
- ❌ `file:///home/ubuntu/smsa_clone/index.html`
- ✅ `http://localhost:8000`

### Le paiement ne fonctionne pas
**Solution** : Vérifiez les permissions du dossier logs
```bash
chmod 755 /home/ubuntu/smsa_clone/logs
```

### Erreur 500 dans le navigateur
**Solution** : Vérifiez les logs PHP
```bash
tail -f /var/log/php_errors.log
```

## 📱 Test sur Appareil Mobile

### Depuis le Même Réseau
1. Trouvez l'adresse IP de votre machine :
   ```bash
   ifconfig | grep "inet "
   ```
2. Sur votre téléphone, accédez à :
   ```
   http://<VOTRE_IP>:8000
   ```

### Utiliser ngrok pour l'Accès Public
```bash
# Installer ngrok
brew install ngrok  # macOS
# ou télécharger depuis ngrok.com

# Exposer le serveur
ngrok http 8000
```

## 🎯 Prochaines Étapes

1. **Personnaliser les Données** : Modifiez les numéros de suivi et les informations
2. **Ajouter une Base de Données** : Intégrez MySQL pour stocker les données réelles
3. **Implémenter une Vraie Passerelle de Paiement** : Utilisez Stripe, PayPal, etc.
4. **Ajouter l'Authentification** : Implémentez la connexion utilisateur
5. **Déployer en Production** : Utilisez un serveur web professionnel

## 📞 Support et Ressources

- **Documentation PHP** : https://www.php.net/docs.php
- **MDN Web Docs** : https://developer.mozilla.org/
- **Stack Overflow** : https://stackoverflow.com/

## ✅ Checklist de Déploiement

- [ ] PHP installé et fonctionnel
- [ ] Serveur démarré sans erreurs
- [ ] Page d'accueil accessible
- [ ] CSS et JavaScript chargés correctement
- [ ] Suivi de colis fonctionnel
- [ ] Paiement fonctionnel
- [ ] Logs créés correctement
- [ ] Tests sur mobile réussis
- [ ] Permissions des fichiers correctes
- [ ] Prêt pour la production

---

**Dernière mise à jour** : 6 février 2026
**Version** : 1.0
