# 🚀 Guide de Démarrage Rapide - SMSA Express

## Flux de Paiement Complet Intégré

### 📌 Résumé du flux

```
1️⃣ Paiement (Payment Form)
   ↓ Clic sur "Pay Now"
2️⃣ Vérification OTP
   ↓ Entrée du code OTP
3️⃣ Chargement (Processing)
   ↓ Attente automatique 6 secondes
4️⃣ Succès (Success Confirmation)
```

---

## 🎯 Démarrer immédiatement

### Option 1 : Ouvrir directement dans le navigateur
```
1. Extraire le fichier smsa_complete.zip
2. Double-cliquer sur index.html (ou index_ar.html pour l'arabe)
3. Remplir le formulaire de paiement
4. Cliquer sur "Pay Now" / "ادفع الآن"
```

### Option 2 : Serveur local (recommandé)

**Avec Python 3 :**
```bash
cd smsa_complete
python3 -m http.server 8000
# Accéder à : http://localhost:8000
```

**Avec Node.js :**
```bash
cd smsa_complete
npx http-server
# Accéder à : http://localhost:8080
```

**Avec PHP :**
```bash
cd smsa_complete
php -S localhost:8000
# Accéder à : http://localhost:8000
```

---

## 📝 Données de test

Utilisez ces données pour tester le flux :

| Champ | Valeur |
|-------|--------|
| **Nom complet** | John Doe |
| **Email** | john@example.com |
| **Numéro de carte** | 4532 1234 5678 9010 |
| **Date d'expiration** | 12/25 |
| **CVV** | 123 |
| **Code OTP** | 123456 (ou n'importe quel code à 6 chiffres) |

---

## 🌐 Langues supportées

### Anglais 🇬🇧
- **index.html** - Page de paiement
- **otp.html** - Vérification OTP
- **loading.html** - Chargement
- **success.html** - Succès

### Arabe 🇸🇦
- **index_ar.html** - صفحة الدفع
- **otp_ar.html** - التحقق من OTP
- **loading_ar.html** - التحميل
- **success_ar.html** - النجاح

---

## 🔑 Fonctionnalités clés

✅ **Flux complet intégré** - Paiement → OTP → Chargement → Succès  
✅ **Support bilingue** - Anglais et Arabe avec RTL  
✅ **Validation de formulaire** - Validation complète des données  
✅ **Animations fluides** - Transitions et animations professionnelles  
✅ **Responsive design** - Fonctionne sur tous les appareils  
✅ **Stockage de session** - Données persistantes pendant la session  
✅ **Sécurité** - Effacement automatique des données sensibles  

---

## 📂 Structure du projet

```
smsa_complete/
├── index.html              # Page de paiement (EN)
├── index_ar.html          # Page de paiement (AR)
├── otp.html               # Page OTP (EN)
├── otp_ar.html           # Page OTP (AR)
├── loading.html          # Page de chargement (EN)
├── loading_ar.html       # Page de chargement (AR)
├── success.html          # Page de succès (EN)
├── success_ar.html       # Page de succès (AR)
├── css/
│   ├── header.css        # Styles du header
│   └── style.css         # Styles principaux
├── js/
│   ├── payment_flow.js   # Gestion du flux de paiement
│   ├── otp_flow.js       # Gestion du flux OTP
│   ├── loading_flow.js   # Gestion du flux de chargement
│   └── success_flow.js   # Gestion du flux de succès
├── images/               # Images du projet
└── FLUX_COMPLET.md      # Documentation complète
```

---

## 🔄 Étapes du flux en détail

### Étape 1️⃣ : Formulaire de Paiement
- Entrer le nom complet
- Entrer l'adresse email
- Entrer le numéro de carte (16 chiffres)
- Entrer la date d'expiration (MM/YY)
- Entrer le CVV (3-4 chiffres)
- Cliquer sur "Pay Now"

### Étape 2️⃣ : Vérification OTP
- Entrer le code OTP à 6 chiffres
- Navigation automatique entre les champs
- Cliquer sur "Verify OTP"
- Ou attendre la redirection automatique

### Étape 3️⃣ : Chargement
- Affichage du spinner
- Progression des étapes
- Barre de progression
- Redirection automatique après 6 secondes

### Étape 4️⃣ : Confirmation de succès
- Affichage du numéro de référence
- Détails de la transaction
- Montant payé
- Boutons pour imprimer ou retourner

---

## 🎨 Personnalisation

### Modifier les couleurs
Éditer `css/style.css` :
```css
--primary-color: #00c8e1;
--secondary-color: #153c3f;
--accent-color: #146e82;
```

### Modifier les délais
Éditer les fichiers JS :
```javascript
// OTP Timer (otp_flow.js)
let timeLeft = 59;

// Loading Duration (loading_flow.js)
setTimeout(() => { ... }, 6000);
```

### Modifier les messages
Éditer les fichiers HTML ou les variables JavaScript

---

## 🐛 Dépannage

| Problème | Solution |
|----------|----------|
| Le flux ne fonctionne pas | Vérifier la console (F12) pour les erreurs |
| Les données ne s'affichent pas | Vérifier que sessionStorage est activé |
| La redirection ne fonctionne pas | Vérifier que tous les fichiers existent |
| Les styles ne s'appliquent pas | Vérifier les chemins CSS |

---

## 📞 Besoin d'aide ?

Consultez le fichier `FLUX_COMPLET.md` pour la documentation complète.

---

**Prêt à démarrer ? Ouvrez `index.html` ou `index_ar.html` maintenant ! 🚀**

Version 1.0 | 07 Février 2026
