# Brainstorming Design - Formulaire d'inscription Ameli.fr

<response>
<idea>

## Approche 1 : Institutionnel Moderne

**Design Movement** : Flat Design Gouvernemental / Service Public Numérique (inspiré des sites .gouv.fr et Ameli.fr)

**Core Principles** :
1. Clarté et accessibilité avant tout — chaque élément doit être immédiatement compréhensible
2. Confiance institutionnelle — le design inspire la sécurité et le sérieux d'un service public
3. Hiérarchie visuelle forte — guider l'utilisateur étape par étape dans le formulaire

**Color Philosophy** : Bleu Ameli (#0C419A) comme couleur dominante, évoquant la confiance et l'autorité. Blanc pur pour le fond, gris clair (#F5F5F5) pour les sections secondaires. Accents verts (#00A651) pour les validations et confirmations. Le bleu rappelle directement l'identité de l'Assurance Maladie.

**Layout Paradigm** : Formulaire centré sur fond clair avec une barre de navigation supérieure bleue. Structure en carte blanche avec ombre légère sur fond gris très clair. Progression verticale naturelle.

**Signature Elements** :
1. Barre supérieure bleue avec logo "ameli" en blanc
2. Icônes de sécurité (cadenas) près des champs sensibles
3. Indicateur de progression par étapes

**Interaction Philosophy** : Validation en temps réel des champs, feedback visuel immédiat (bordures vertes/rouges), transitions douces entre les états.

**Animation** : Transitions subtiles de 200ms sur les focus des champs. Apparition progressive des messages d'erreur. Pas d'animation excessive — le sérieux institutionnel prime.

**Typography System** : Source Sans Pro pour le corps (lisibilité gouvernementale), Marianne ou Open Sans pour les titres. Tailles généreuses pour l'accessibilité.

</idea>
<text>Un design fidèle au style institutionnel d'Ameli.fr, épuré et professionnel, centré sur la confiance et l'accessibilité.</text>
<probability>0.08</probability>
</response>

<response>
<idea>

## Approche 2 : Glassmorphism Santé

**Design Movement** : Glassmorphism avec touches de design médical contemporain

**Core Principles** :
1. Transparence et modernité — effets de verre dépoli pour un look premium
2. Douceur médicale — courbes et formes organiques évoquant le soin
3. Luminosité — palette claire et aérée inspirant la propreté

**Color Philosophy** : Bleu glacier (#E8F4FD) en fond avec des dégradés vers le blanc. Bleu profond (#1A3B6B) pour le texte principal. Accents turquoise (#00B4D8) pour les éléments interactifs. Le tout évoque un environnement médical moderne et rassurant.

**Layout Paradigm** : Formulaire en panneau de verre dépoli flottant au centre, avec un fond de formes organiques bleues en arrière-plan. Asymétrie contrôlée avec le logo à gauche et le formulaire décalé à droite.

**Signature Elements** :
1. Panneaux en verre dépoli (backdrop-blur) avec bordures translucides
2. Formes blob organiques en arrière-plan animées lentement
3. Icônes médicales stylisées (croix, cœur, bouclier)

**Interaction Philosophy** : Hover avec effet de profondeur sur les champs, micro-animations sur les icônes, transitions fluides entre les étapes du formulaire.

**Animation** : Blobs en arrière-plan avec mouvement lent (15s cycle). Champs qui s'illuminent au focus avec un glow bleu. Bouton de soumission avec effet de pulse.

**Typography System** : Poppins pour les titres (rondeur moderne), Inter pour le corps. Contraste fort entre les poids (700 titres, 400 corps).

</idea>
<text>Un design glassmorphism moderne avec des touches médicales, créant une expérience premium et rassurante.</text>
<probability>0.05</probability>
</response>

<response>
<idea>

## Approche 3 : Néo-Brutalisme Administratif

**Design Movement** : Néo-Brutalisme appliqué au design de service public

**Core Principles** :
1. Honnêteté visuelle — les éléments sont ce qu'ils sont, sans artifice
2. Contraste maximal — bordures nettes, ombres portées dures
3. Efficacité directe — l'utilisateur comprend immédiatement quoi faire

**Color Philosophy** : Fond jaune pâle (#FFF8E1) avec le bleu Ameli (#0C419A) en couleur d'action. Bordures noires épaisses (2-3px) pour délimiter clairement les zones. Rouge vif (#FF4444) pour les erreurs. Le contraste fort assure une lisibilité maximale.

**Layout Paradigm** : Grille asymétrique avec le formulaire dans un cadre à bordure épaisse. Éléments empilés avec des décalages intentionnels. Titre en très grande taille en haut à gauche.

**Signature Elements** :
1. Bordures noires épaisses sur tous les conteneurs
2. Ombres portées dures décalées (4px, 4px)
3. Typographie surdimensionnée pour les titres

**Interaction Philosophy** : Hover avec décalage de l'ombre, clic avec effet d'enfoncement, feedback brutal et immédiat sur les erreurs.

**Animation** : Transitions rapides (100ms), effet de "stamp" sur la validation, shake sur les erreurs. Mouvement minimal mais impactant.

**Typography System** : Space Grotesk pour les titres (géométrique, brut), DM Sans pour le corps. Tailles très contrastées (48px titre vs 16px corps).

</idea>
<text>Un design néo-brutaliste audacieux qui rend le formulaire administratif visuellement percutant et mémorable.</text>
<probability>0.03</probability>
</response>
