/**
 * AmeliHeader - Header fidèle au thème ameliconnect.ameli.fr
 * Design : Logo Assurance Maladie à gauche, séparateur, "Compte ameli" à droite
 * Barre bleue fine sous le header
 */

export default function AmeliHeader() {
  return (
    <header className="w-full bg-white">
      <div className="max-w-[960px] mx-auto px-4 py-4 flex items-center gap-4">
        {/* Logo Assurance Maladie */}
        <div className="flex items-center gap-3">
          <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
            <circle cx="24" cy="24" r="22" fill="#0C419A" opacity="0.1"/>
            <g transform="translate(8, 6)">
              <circle cx="10" cy="8" r="4" fill="#0C419A"/>
              <circle cx="22" cy="8" r="3.5" fill="#2980B9"/>
              <circle cx="16" cy="5" r="3" fill="#1A6CB0"/>
              <path d="M4 28 C4 20, 10 16, 16 16 C22 16, 28 20, 28 28" stroke="#0C419A" strokeWidth="2.5" fill="none" strokeLinecap="round"/>
              <path d="M8 26 C8 22, 12 19, 16 19 C20 19, 24 22, 24 26" stroke="#2980B9" strokeWidth="2" fill="none" strokeLinecap="round"/>
            </g>
          </svg>
          <div className="leading-tight">
            <div className="text-[11px] text-[#0C419A] font-semibold tracking-wider uppercase">Sécurité Sociale</div>
            <div className="text-[#0C419A] font-bold text-lg leading-tight">l'Assurance</div>
            <div className="text-[#0C419A] font-bold text-lg leading-tight">Maladie</div>
            <div className="text-[#6B7280] text-[10px] italic">Agir ensemble, protéger chacun</div>
          </div>
        </div>

        {/* Séparateur vertical */}
        <div className="h-12 w-px bg-[#D1D5DB] mx-2"></div>

        {/* Compte ameli */}
        <div className="flex items-baseline gap-1.5">
          <span className="text-[#333333] text-lg font-light">Compte</span>
          <span className="text-[#0C419A] text-lg font-bold">ameli</span>
        </div>
      </div>

      {/* Barre bleue sous le header */}
      <div className="w-full h-1 bg-gradient-to-r from-[#0C419A] via-[#1565C0] to-[#0C419A]"></div>
    </header>
  );
}
