/**
 * AmeliFooter - Footer fidèle au thème ameliconnect.ameli.fr
 * Design : Liens institutionnels, mentions légales
 */

export default function AmeliFooter() {
  return (
    <footer className="w-full bg-[#F5F7FA] border-t border-[#D5D5D5] mt-auto">
      <div className="max-w-[960px] mx-auto px-4 py-6">
        <div className="flex flex-wrap items-center justify-center gap-4 text-sm text-[#6B7280]">
          <a href="#" className="hover:text-[#0C419A] transition-colors">Mentions légales</a>
          <span className="text-[#D1D5DB]">|</span>
          <a href="#" className="hover:text-[#0C419A] transition-colors">Données personnelles</a>
          <span className="text-[#D1D5DB]">|</span>
          <a href="#" className="hover:text-[#0C419A] transition-colors">Accessibilité</a>
          <span className="text-[#D1D5DB]">|</span>
          <a href="#" className="hover:text-[#0C419A] transition-colors">Plan du site</a>
          <span className="text-[#D1D5DB]">|</span>
          <a href="#" className="hover:text-[#0C419A] transition-colors">Nous contacter</a>
        </div>
        <p className="text-center text-xs text-[#9CA3AF] mt-4">
          © {new Date().getFullYear()} - Caisse nationale de l'Assurance Maladie
        </p>
      </div>
    </footer>
  );
}
